<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Subscription extends Model 
{

    protected $table = 'subscriptions';
    public $timestamps = true;
    protected $fillable = array('client_id', 'agent_id', 'software_serial', 'domain', 'price', 'agent_percentage', 'net_price', 'payment_method', 'payment_status', 'payment_date', 'renew', 'renew_duration');

    public function agent()
    {
        return $this->belongsTo('App\Models\Agent');
    }

    public function client()
    {
        return $this->belongsTo('App\Models\Client');
    }

    public function changeDevices()
    {
        return $this->hasMany('App\Models\ChangeDevice');
    }

    public function clientPayments()
    {
        return $this->hasMany('App\Models\ClientPayment');
    }

    public function service()
    {
        return $this->belongsTo('App\Models\Service');
    }

}